unit ModifyCascadeFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, ModifyCascadeFrame;

type
  TModifyCascadeFrameG = class(TModifyCascadeFrame)
    procedure btModifyCascadeClick(Sender: TObject);
    procedure btCanceCascadeClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}


procedure TModifyCascadeFrameG.Initialize;
begin
  inherited;

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdDetail);
end;

procedure TModifyCascadeFrameG.btModifyCascadeClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  Dept := DemoContext.GetEntities<TDept>.First;

  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  // Modify Emps
  for i := 0 to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    Emp.Ename := 'EName ' + IntToStr(Round(Random(99)));
  end;

  // Save cascade
  Dept.Save(True);

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TModifyCascadeFrameG.btCanceCascadeClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  Dept := DemoContext.GetEntities<TDept>.First;

  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  // Modify Emps
  for i := 0 to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    Emp.Ename := 'EName ' + IntToStr(Round(Random(99)));
  end;

  // Save cascade
  Dept.Cancel(True);

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

end.
