unit ModifyCascadeFrameM;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, ModifyCascadeFrame;

type
  TModifyCascadeFrameM = class(TModifyCascadeFrame)
    procedure btModifyCascadeClick(Sender: TObject);
    procedure btCanceCascadeClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}


procedure TModifyCascadeFrameM.Initialize;
begin
  inherited;

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);
end;

procedure TModifyCascadeFrameM.btModifyCascadeClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  Dept := DemoContext.GetEntities(TDept).First as TDept;

  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  // Modify Emps
  for i := 0 to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    Emp.Ename := 'EName ' + IntToStr(Round(Random(99)));
  end;

  // Save cascade
  Dept.Save(True);

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TModifyCascadeFrameM.btCanceCascadeClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  Dept := DemoContext.GetEntities(TDept).First as TDept;

  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  // Modify Emps
  for i := 0 to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    Emp.Ename := 'EName ' + IntToStr(Round(Random(99)));
  end;

  // Save cascade
  Dept.Cancel(True);

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

end.
