unit ModifyCascadeFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Objects,
  DemoFrame, DataContextFrame, ModifyCascadeFrame;

type
  TModifyCascadeFrameO = class(TModifyCascadeFrame)
    procedure btModifyCascadeClick(Sender: TObject);
    procedure btCanceCascadeClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}


procedure TModifyCascadeFrameO.Initialize;
begin
  inherited;

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);
end;

procedure TModifyCascadeFrameO.btModifyCascadeClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  Dept := ObjectContext.GetEntities<TDept>.First;

  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  // Modify Emps
  for i := 0 to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    Emp.Ename := 'EName ' + IntToStr(Round(Random(99)));
  end;

  // Save cascade
  ObjectContext.Save(Dept, True);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TModifyCascadeFrameO.btCanceCascadeClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  Dept := ObjectContext.GetEntities<TDept>.First;

  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  // Modify Emps
  for i := 0 to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    Emp.Ename := 'EName ' + IntToStr(Round(Random(99)));
  end;

  // Save cascade
  ObjectContext.Cancel(Dept, True);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

end.
