unit ModifyEntityFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.AttributeClasses,
  DemoFrame, DataContextFrame, ModifyEntityFrame;

type
  TModifyEntityFrameE = class(TModifyEntityFrame)
    procedure btModifyEntityClick(Sender: TObject);
    procedure btCancelModifyClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}


procedure TModifyEntityFrameE.Initialize;
begin
  inherited;

  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdResult);
end;

procedure TModifyEntityFrameE.btModifyEntityClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityContext.GetEntities(TEmp).Last as TEmp;

  // Modify entity attributes
  Emp.Ename := 'Name ' + IntToStr(Round(Random(99)));
  // Save changes
  Emp.Save;

  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdResult);

  inherited;
end;

procedure TModifyEntityFrameE.btCancelModifyClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityContext.GetEntities(TEmp).Last as TEmp;

  // Modify entity attributes
  Emp.Ename := 'Name ' + IntToStr(Round(Random(99)));
  // Cancel changes
  Emp.Cancel;

  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdResult);

  inherited;
end;

end.
