unit ModifyEntityFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, ModifyEntityFrame;

type
  TModifyEntityFrameG = class(TModifyEntityFrame)
    DBNavigator1: TDBNavigator;
    procedure btModifyEntityClick(Sender: TObject);
    procedure btCancelModifyClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}


procedure TModifyEntityFrameG.Initialize;
begin
  inherited;

  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdResult);
end;

procedure TModifyEntityFrameG.btModifyEntityClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities<TEmp>.Last;

  // Modify entity attributes
  Emp.Ename := 'Name ' + IntToStr(Round(Random(99)));
  // Save changes
  Emp.Save;

  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdResult);

  inherited;
end;

procedure TModifyEntityFrameG.btCancelModifyClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities<TEmp>.Last;

  // Modify entity attributes
  Emp.Ename := 'Name ' + IntToStr(Round(Random(99)));
  // Cancel changes
  Emp.Cancel;

  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdResult);

  inherited;
end;

end.
