unit ModifyEntityFrameM;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, ModifyEntityFrame;

type
  TModifyEntityFrameM = class(TModifyEntityFrame)
    procedure btModifyEntityClick(Sender: TObject);
    procedure btCancelModifyClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}


procedure TModifyEntityFrameM.Initialize;
begin
  inherited;

  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdResult);
end;

procedure TModifyEntityFrameM.btModifyEntityClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities(TEmp).Last as TEmp;

  // Modify entity attributes
  Emp.Ename := 'Name ' + IntToStr(Round(Random(99)));
  // Save changes
  Emp.Save;

  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdResult);

  inherited;
end;

procedure TModifyEntityFrameM.btCancelModifyClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities(TEmp).Last as TEmp;

  // Modify entity attributes
  Emp.Ename := 'Name ' + IntToStr(Round(Random(99)));
  // Cancel changes
  Emp.Cancel;

  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdResult);

  inherited;
end;

end.
