unit ModifyEntityFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Objects,
  DemoFrame, DataContextFrame, ModifyEntityFrame;

type
  TModifyEntityFrameO = class(TModifyEntityFrame)
    DBNavigator1: TDBNavigator;
    procedure btModifyEntityClick(Sender: TObject);
    procedure btCancelModifyClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}


procedure TModifyEntityFrameO.Initialize;
begin
  inherited;

  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdResult);
end;

procedure TModifyEntityFrameO.btModifyEntityClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := ObjectContext.GetEntities<TEmp>.Last;

  // Modify entity attributes
  Emp.Ename := 'Name ' + IntToStr(Round(Random(99)));
  // Save changes
  ObjectContext.Save(Emp);

  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdResult);

  inherited;
end;

procedure TModifyEntityFrameO.btCancelModifyClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := ObjectContext.GetEntities<TEmp>.Last;

  // Modify entity attributes
  Emp.Ename := 'Name ' + IntToStr(Round(Random(99)));
  // Cancel changes
  ObjectContext.Cancel(Emp);

  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdResult);

  inherited;
end;

end.
