unit NullableTypesFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  DemoFrame, DataContextFrame, NullableTypesFrame,
  Demo.AttributeClasses;

type
  TNullableTypesFrameE = class(TNullableTypesFrame)
    DBNavigator1: TDBNavigator;
    procedure btSetNumericClick(Sender: TObject);
    procedure btSetNullClick(Sender: TObject);
    procedure btGetNullableClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.NullableTypes;

procedure TNullableTypesFrameE.btGetNullableClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityContext.GetEntities(TEmp).Last as TEmp;

  mmResult.Lines.Add('---');
  if not Emp.Comm.HasValue then
    mmResult.Lines.Add('Emp.Comm is NULL')
  else
    mmResult.Lines.Add('Emp.Comm = ' + FloatToStr(Emp.Comm.Value));
  mmResult.Lines.Add('---');
end;

procedure TNullableTypesFrameE.btSetNullClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityContext.GetEntities(TEmp).Last as TEmp;

  // Set NULL
  Emp.Comm := Null;

  Emp.Save;
  EntityToMemo(Emp, mmResult);

  inherited;
end;

procedure TNullableTypesFrameE.btSetNumericClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityContext.GetEntities(TEmp).Last as TEmp;

  // Set numeric Value
  Emp.Comm := 501;

  Emp.Save;
  EntityToMemo(Emp, mmResult);

  inherited;
end;

end.
