unit NullableTypesFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  DemoFrame, DataContextFrame, NullableTypesFrame,
  Demo.Classes,
  Demo.Linq;

type
  TNullableTypesFrameG = class(TNullableTypesFrame)
    DBNavigator1: TDBNavigator;
    procedure btSetNumericClick(Sender: TObject);
    procedure btSetNullClick(Sender: TObject);
    procedure btGetNullableClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.NullableTypes;

procedure TNullableTypesFrameG.btGetNullableClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities<TEmp>.Last;

  mmResult.Lines.Add('---');
  if not Emp.Comm.HasValue then
    mmResult.Lines.Add('Emp.Comm is NULL')
  else
    mmResult.Lines.Add('Emp.Comm = ' + FloatToStr(Emp.Comm.Value));
  mmResult.Lines.Add('---');
end;

procedure TNullableTypesFrameG.btSetNullClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities<TEmp>.Last;

  // Set NULL
  Emp.Comm := Null;

  Emp.Save;
  EntityToMemo(Emp, mmResult);

  inherited;
end;

procedure TNullableTypesFrameG.btSetNumericClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities<TEmp>.Last;

  // Set numeric Value
  Emp.Comm := 501;

  Emp.Save;
  EntityToMemo(Emp, mmResult);

  inherited;
end;

end.
