unit NullableTypesFrameM;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  DemoFrame, DataContextFrame, NullableTypesFrame,
  Demo.Classes,
  Demo.Linq;

type
  TNullableTypesFrameM = class(TNullableTypesFrame)
    DBNavigator1: TDBNavigator;
    procedure btSetNumericClick(Sender: TObject);
    procedure btSetNullClick(Sender: TObject);
    procedure btGetNullableClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.NullableTypes;

procedure TNullableTypesFrameM.btGetNullableClick(Sender: TObject);
{$IFDEF VER12P}
var
  Emp: TEmp;
{$ENDIF}
begin
{$IFDEF VER12P}
  Emp := DemoContext.GetEntities(TEmp).Last as TEmp;

  mmResult.Lines.Add('---');
  if not Emp.Comm.HasValue then
    mmResult.Lines.Add('Emp.Comm is NULL')
  else
    mmResult.Lines.Add('Emp.Comm = ' + FloatToStr(Emp.Comm.Value));
{$ENDIF}
  mmResult.Lines.Add('---');
end;

procedure TNullableTypesFrameM.btSetNullClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities(TEmp).Last as TEmp;

  // Set NULL
  Emp.Comm := Null;

  Emp.Save;
  EntityToMemo(Emp, mmResult);

  inherited;
end;

procedure TNullableTypesFrameM.btSetNumericClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities(TEmp).Last as TEmp;

  // Set numeric Value
  Emp.Comm := 501;

  Emp.Save;
  EntityToMemo(Emp, mmResult);

  inherited;
end;

end.
