unit NullableTypesFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  DemoFrame, DataContextFrame, NullableTypesFrame,
  Demo.Objects;

type
  TNullableTypesFrameO = class(TNullableTypesFrame)
    DBNavigator1: TDBNavigator;
    procedure btSetNumericClick(Sender: TObject);
    procedure btSetNullClick(Sender: TObject);
    procedure btGetNullableClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.NullableTypes;

procedure TNullableTypesFrameO.btGetNullableClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := ObjectContext.GetEntities<TEmp>.Last;

  mmResult.Lines.Add('---');
  if not Emp.Comm.HasValue then
    mmResult.Lines.Add('Emp.Comm is NULL')
  else
    mmResult.Lines.Add('Emp.Comm = ' + FloatToStr(Emp.Comm.Value));
  mmResult.Lines.Add('---');
end;

procedure TNullableTypesFrameO.btSetNullClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := ObjectContext.GetEntities<TEmp>.Last;

  // Set NULL
  Emp.Comm := Null;

  ObjectContext.Save(Emp);
  EntityToMemo(Emp, mmResult);

  inherited;
end;

procedure TNullableTypesFrameO.btSetNumericClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := ObjectContext.GetEntities<TEmp>.Last;

  // Set numeric Value
  Emp.Comm := 501;

  ObjectContext.Save(Emp);
  EntityToMemo(Emp, mmResult);

  inherited;
end;

end.
