unit SubmitChangesFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, DB, Grids, DBGrids, DBCtrls,
  Forms, Dialogs,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  Demo.AttributeClasses,
  DemoFrame, DataContextFrame, SubmitChangesFrame;

type
  TSubmitChangesFrameE = class(TSubmitChangesFrame)
    procedure btSubmitChangesClick(Sender: TObject);
    procedure btRejectChangesClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TSubmitChangesFrameE.Initialize;
begin
  inherited;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);
end;

procedure TSubmitChangesFrameE.btSubmitChangesClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := EntityContext.GetEntities(TDept).Last as TDept;
  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  Dept := EntityContext.GetEntities(TDept).First as TDept;
  // Modify Emps
  if Dept.Emps.Count > 0 then
    Dept.Emps[0].Delete;
  if Dept.Emps.Count > 1 then
    Dept.Emps[1].Ename := 'EName ' + IntToStr(Round(Random(99)));

  // Save all changes to Database
  EntityContext.SubmitChanges;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TSubmitChangesFrameE.btRejectChangesClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := EntityContext.GetEntities(TDept).Last as TDept;
  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  Dept := EntityContext.GetEntities(TDept).First as TDept;
  // Modify Emps
  if Dept.Emps.Count > 0 then
    Dept.Emps[0].Delete;
  if Dept.Emps.Count > 1 then
    Dept.Emps[1].Ename := 'EName ' + IntToStr(Round(Random(99)));

  // Save all changes to Database
  EntityContext.RejectChanges;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

end.
