unit SubmitChangesFrameM;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, DB, Grids, DBGrids, DBCtrls,
  Forms, Dialogs,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, SubmitChangesFrame;

type
  TSubmitChangesFrameM = class(TSubmitChangesFrame)
    procedure btSubmitChangesClick(Sender: TObject);
    procedure btRejectChangesClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TSubmitChangesFrameM.Initialize;
begin
  inherited;

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);
end;

procedure TSubmitChangesFrameM.btSubmitChangesClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities(TDept).Last as TDept;
  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  Dept := DemoContext.GetEntities(TDept).First as TDept;
  // Modify Emps
  if Dept.Emps.Count > 0 then
    Dept.Emps[0].Delete;
  if Dept.Emps.Count > 1 then
    Dept.Emps[1].Ename := 'EName ' + IntToStr(Round(Random(99)));

  // Save all changes to Database
  DemoContext.SubmitChanges;

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TSubmitChangesFrameM.btRejectChangesClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities(TDept).Last as TDept;
  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  Dept := DemoContext.GetEntities(TDept).First as TDept;
  // Modify Emps
  if Dept.Emps.Count > 0 then
    Dept.Emps[0].Delete;
  if Dept.Emps.Count > 1 then
    Dept.Emps[1].Ename := 'EName ' + IntToStr(Round(Random(99)));

  // Save all changes to Database
  DemoContext.RejectChanges;

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

end.
