unit SubmitChangesFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, DB, Grids, DBGrids, DBCtrls,
  Forms, Dialogs,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  Demo.Objects,
  DemoFrame, DataContextFrame, SubmitChangesFrame;

type
  TSubmitChangesFrameO = class(TSubmitChangesFrame)
    procedure btSubmitChangesClick(Sender: TObject);
    procedure btRejectChangesClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TSubmitChangesFrameO.Initialize;
begin
  inherited;

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);
end;

procedure TSubmitChangesFrameO.btSubmitChangesClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntities<TDept>.Last;
  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  Dept := ObjectContext.GetEntities<TDept>.First;
  // Modify Emps
  if Dept.Emps.Count > 0 then
    ObjectContext.Delete(Dept.Emps[0]);
  if Dept.Emps.Count > 1 then
    Dept.Emps[1].Ename := 'EName ' + IntToStr(Round(Random(99)));

  // Save all changes to Database
  ObjectContext.SubmitChanges;

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TSubmitChangesFrameO.btRejectChangesClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntities<TDept>.Last;
  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  Dept := ObjectContext.GetEntities<TDept>.First;
  // Modify Emps
  if Dept.Emps.Count > 0 then
    ObjectContext.Delete(Dept.Emps[0]);
  if Dept.Emps.Count > 1 then
    Dept.Emps[1].Ename := 'EName ' + IntToStr(Round(Random(99)));

  // Save all changes to Database
  ObjectContext.RejectChanges;

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

end.
