unit EdtityDataSetMDFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls,
  Forms, Dialogs, DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Common.DataSet,
  EntityDAC.Common.VirtualDataSet,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  EntityDAC.EntityDataSet,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataSetFrame, DataContextFrame;

type
  TEdtityDataSetMDFrame = class(TDataSetFrame)
    btMDbyFields: TButton;
    gdrDetail: TDBGrid;
    DBNavigator1: TDBNavigator;
    MasterDataSet: TEntityDataSet;
    MasterDataSource: TDataSource;
    grdMaster: TDBGrid;
    Splitter1: TSplitter;
    DetailDataSet: TEntityDataSet;
    DetailDataSource: TDataSource;
    btMDbyReference: TButton;
    btMDbyExpression: TButton;
    procedure btMDbyFieldsClick(Sender: TObject);
    procedure btMDbyExpressionClick(Sender: TObject);
    procedure btMDbyReferenceClick(Sender: TObject);
  private
  public
    procedure Initialize; override;
    procedure Finalize; override;
  end;

implementation

{$R *.dfm}

{ TFrameODC }

procedure TEdtityDataSetMDFrame.Initialize;
begin
  inherited;
  grdMaster.Width := 300;
end;

procedure TEdtityDataSetMDFrame.btMDbyExpressionClick(Sender: TObject);
var
  Depts: IEntityEnumerable;
  Emps: IEntityEnumerable;
begin
  Depts := DemoContext.GetEntities(TDept);
  Emps := DemoContext.GetEntities(TEmp);

  MasterDataSet.SourceCollection := Depts;
  MasterDataSet.Open;

  DetailDataSet.SourceCollection := Emps;
  DetailDataSet.MasterSource := MasterDataSource;
  DetailDataSet.MasterFields := DemoContext.Model.Dept.DeptNo.Name;
  DetailDataSet.DetailFields := DemoContext.Model.Emp.DeptNo.Name;
  DetailDataSet.Open;

  ShowDemoPiece(Sender);
end;

procedure TEdtityDataSetMDFrame.btMDbyFieldsClick(Sender: TObject);
var
  Depts: IEntityEnumerable;
  Emps: IEntityEnumerable;
begin
  Depts := DemoContext.GetEntities(TDept);
  Emps := DemoContext.GetEntities(TEmp);

  MasterDataSet.SourceCollection := Depts;
  MasterDataSet.Open;

  DetailDataSet.SourceCollection := Emps;
  DetailDataSet.MasterSource := MasterDataSource;
  DetailDataSet.MasterFields := 'Deptno';
  DetailDataSet.DetailFields := 'Deptno';
  DetailDataSet.Open;

  ShowDemoPiece(Sender);
end;

procedure TEdtityDataSetMDFrame.btMDbyReferenceClick(Sender: TObject);
var
  Depts: IEntityEnumerable;
  Emps: IEntityEnumerable;
begin
  Depts := DemoContext.GetEntities(TDept);
  Emps := DemoContext.GetEntities(TEmp);

  MasterDataSet.SourceCollection := Depts;
  MasterDataSet.Open;

  DetailDataSet.SourceCollection := Emps;
  DetailDataSet.MasterSource := MasterDataSource;
  DetailDataSet.MasterReference := DemoContext.Emp.Dept;
  DetailDataSet.Open;

  ShowDemoPiece(Sender);
end;

procedure TEdtityDataSetMDFrame.Finalize;
begin
  inherited;
end;

end.
