unit EntitiesToDataSetFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls,
  Forms, Dialogs, DB, Grids, DBGrids, Mask, DBCtrls,
  EntityDAC.Common.DataSet,
  EntityDAC.Common.VirtualDataSet,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  EntityDAC.EntityDataSet,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, DataSetFrame;

type
  TEntitiesToDataSetFrame = class(TDataSetFrame)
    btCollectionToDataSet: TButton;
    btLinqCollectionToDataSet: TButton;
    grdResult: TDBGrid;
    DBNavigator1: TDBNavigator;
    EntityDataSet1: TEntityDataSet;
    DataSource1: TDataSource;
    Label1: TLabel;
    edDeptNo: TDBEdit;
    edEName: TDBEdit;
    Label3: TLabel;
    Label2: TLabel;
    edJob: TDBEdit;
    Label4: TLabel;
    edEmpNo: TDBEdit;
    Label6: TLabel;
    edHireDate: TDBEdit;
    edSalary: TDBEdit;
    Label5: TLabel;
    edComm: TDBEdit;
    Label7: TLabel;
    procedure btCollectionToDataSetClick(Sender: TObject);
    procedure btLinqCollectionToDataSetClick(Sender: TObject);
  private
  public
    procedure Initialize; override;
    procedure Finalize; override;
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Linq;

{ TFrameODC }

procedure TEntitiesToDataSetFrame.Initialize;
begin
  inherited;
end;

procedure TEntitiesToDataSetFrame.btCollectionToDataSetClick(Sender: TObject);
var
  Emps: IEntityEnumerable;
begin
  // classic by class type
  Emps := DemoContext.GetEntities(TEmp, 'DeptNo = 20');
  EntityDataSet1.SourceCollection := Emps;
  EntityDataSet1.Open;

  ShowDemoPiece(Sender as TButton, mmSource);
end;

procedure TEntitiesToDataSetFrame.btLinqCollectionToDataSetClick(Sender: TObject);
var
  e: IEmpExpression;
  Query: ILinqQueryable;
begin
  e := DemoContext.Emp;
  Query := Linq.From(e).Where(e.Deptno > 20).Select;
  EntityDataSet1.SourceCollection := DemoContext.GetEntities(Query);
  EntityDataSet1.Open;

  ShowDemoPiece(Sender as TButton, mmSource);
end;

procedure TEntitiesToDataSetFrame.Finalize;
begin
  inherited;
end;

end.
