unit EntityDataSetExpressionFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls,
  Forms, Dialogs, DB, Grids, DBGrids, Mask, DBCtrls,
  EntityDAC.Common.DataSet,
  EntityDAC.Common.VirtualDataSet,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  EntityDAC.EntityDataSet,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataSetFrame, DataContextFrame;

type
  TEntityDataSetExpressionFrame = class(TDataSetFrame)
    btAddMathExpression: TButton;
    grdResult: TDBGrid;
    DBNavigator1: TDBNavigator;
    EntityDataSet1: TEntityDataSet;
    DataSource1: TDataSource;
    edEName: TDBEdit;
    Label3: TLabel;
    Label4: TLabel;
    edEmpNo: TDBEdit;
    edExpr1: TDBEdit;
    Label5: TLabel;
    edExpr2: TDBEdit;
    Label7: TLabel;
    Label8: TLabel;
    Edit1: TEdit;
    btAddStrExpression: TButton;
    Label9: TLabel;
    Edit2: TEdit;
    btAddRefExpression: TButton;
    Edit3: TEdit;
    Label1: TLabel;
    btClearMathExpression: TButton;
    btClearStrExpression: TButton;
    btClearRefExpression: TButton;
    Bevel1: TBevel;
    edDName: TDBEdit;
    Label2: TLabel;
    procedure btAddMathExpressionClick(Sender: TObject);
    procedure btAddStrExpressionClick(Sender: TObject);
    procedure btAddRefExpressionClick(Sender: TObject);
    procedure btClearMathExpressionClick(Sender: TObject);
    procedure btClearStrExpressionClick(Sender: TObject);
    procedure btClearRefExpressionClick(Sender: TObject);
  private
  public
    procedure Initialize; override;
    procedure Finalize; override;
  end;

implementation

{$R *.dfm}

{ TFrameODC }

procedure TEntityDataSetExpressionFrame.Initialize;
var
  Emps: IEntityEnumerable;
begin
  inherited;

  Emps := DemoContext.GetEntities(TEmp);
  EntityDataSet1.SourceCollection := Emps;
  EntityDataSet1.Open;
end;

procedure TEntityDataSetExpressionFrame.btClearMathExpressionClick(Sender: TObject);
begin
  edExpr1.DataField := '';
  EntityDataSet1.DeleteFieldExpression('MathExpr');

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetExpressionFrame.btClearRefExpressionClick(Sender: TObject);
begin
  edDName.DataField := '';
  EntityDataSet1.DeleteFieldExpression('DName');

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetExpressionFrame.btClearStrExpressionClick(Sender: TObject);
begin
  edExpr2.DataField := '';
  EntityDataSet1.DeleteFieldExpression('StrExpr');

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetExpressionFrame.btAddMathExpressionClick(Sender: TObject);
begin
  if EntityDataSet1.FindField('MathExpr') = nil then
    EntityDataSet1.AddFieldExpression('MathExpr', 'SAL + 321');

  edExpr1.DataField := 'MathExpr';

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetExpressionFrame.btAddRefExpressionClick(Sender: TObject);
begin
  if EntityDataSet1.FindField('DName') = nil then
    EntityDataSet1.AddFieldExpression('DName', 'Dept.DName');

  edDName.DataField := 'DName';

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetExpressionFrame.btAddStrExpressionClick(Sender: TObject);
begin
  if EntityDataSet1.FindField('StrExpr') = nil then
    EntityDataSet1.AddFieldExpression('StrExpr', 'EName + '' AddedExpr''');

  edExpr2.DataField := 'StrExpr';

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetExpressionFrame.Finalize;
begin
  inherited;
end;

end.
