unit EntityDataSetFilterFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls,
  Forms, Dialogs, DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Common.DataSet,
  EntityDAC.Common.VirtualDataSet,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  EntityDAC.EntityDataSet,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataSetFrame;

type
  TEntityDataSetFilterFrame = class(TDataSetFrame)
    grdResult: TDBGrid;
    DBNavigator1: TDBNavigator;
    EntityDataSet1: TEntityDataSet;
    DataSource1: TDataSource;
    edSimpleFilter: TEdit;
    Label1: TLabel;
    btApplySimpleFilter: TButton;
    btClearSimpleFilter: TButton;
    Edit2: TEdit;
    sdCalculatedFilter: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    edFilterByReference: TEdit;
    btApplyCalculatedFilter: TButton;
    btClearCalculatedFilter: TButton;
    btApplyFilterByReference: TButton;
    btClearFilterByReference: TButton;
    Memo1: TMemo;
    edCustomFilter: TEdit;
    Label4: TLabel;
    btApplyCustomFilter: TButton;
    btClearCustomFilter: TButton;
    procedure btApplySimpleFilterClick(Sender: TObject);
    procedure btClearSimpleFilterClick(Sender: TObject);
    procedure btApplyCalculatedFilterClick(Sender: TObject);
    procedure btClearCalculatedFilterClick(Sender: TObject);
    procedure btApplyFilterByReferenceClick(Sender: TObject);
    procedure btApplyCustomFilterClick(Sender: TObject);
    procedure btClearCustomFilterClick(Sender: TObject);
    procedure btClearFilterByReferenceClick(Sender: TObject);
  private
  public
    procedure Initialize; override;
    procedure Finalize; override;
  end;

implementation

{$R *.dfm}

{ TFrameODC }

procedure TEntityDataSetFilterFrame.Initialize;
var
  Emps: IEntityEnumerable;
begin
  inherited;

  Emps := DemoContext.GetEntities(TEmp);
  EntityDataSet1.SourceCollection := Emps;
  EntityDataSet1.Open;
end;


procedure TEntityDataSetFilterFrame.btApplyCustomFilterClick(Sender: TObject);
begin
  EntityDataSet1.Filter := edCustomFilter.Text;
  EntityDataSet1.Filtered := True;

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetFilterFrame.btApplyFilterByReferenceClick(
  Sender: TObject);
begin
  EntityDataSet1.Filter := 'Dept.DName = ''SALES''';
  EntityDataSet1.Filtered := True;

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetFilterFrame.btApplySimpleFilterClick(Sender: TObject);
begin
  EntityDataSet1.Filter := 'EName = ''JAMES''';
  EntityDataSet1.Filtered := True;

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetFilterFrame.btApplyCalculatedFilterClick(Sender: TObject);
begin
  EntityDataSet1.Filter := 'Sal + 100 >= 1500';
  EntityDataSet1.Filtered := True;

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetFilterFrame.btClearCalculatedFilterClick(
  Sender: TObject);
begin
  EntityDataSet1.Filtered := False;

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetFilterFrame.btClearCustomFilterClick(Sender: TObject);
begin
  EntityDataSet1.Filtered := False;

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetFilterFrame.btClearFilterByReferenceClick(
  Sender: TObject);
begin
  EntityDataSet1.Filtered := False;

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetFilterFrame.btClearSimpleFilterClick(Sender: TObject);
begin
  EntityDataSet1.Filtered := False;

  ShowDemoPiece(Sender);
end;

procedure TEntityDataSetFilterFrame.Finalize;
begin
  inherited;
end;

end.
