unit EntityToDataSetFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Grids, DBGrids, Mask, DBCtrls, DB,
  Forms, Dialogs,
  EntityDAC.Common.DataSet,
  EntityDAC.Common.VirtualDataSet,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  EntityDAC.EntityDataSet,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataSetFrame, DataContextFrame;

type
  TEntityToDataSetFrame = class(TDataSetFrame)
    btEntityToDataSet: TButton;
    grdResult: TDBGrid;
    DBNavigator1: TDBNavigator;
    EntityDataSet1: TEntityDataSet;
    DataSource1: TDataSource;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edLoc: TDBEdit;
    edDName: TDBEdit;
    edDeptNo: TDBEdit;
    procedure btEntityToDataSetClick(Sender: TObject);
  private
  public
    procedure Initialize; override;
    procedure Finalize; override;
  end;

implementation

{$R *.dfm}

{ TFrameODC }

procedure TEntityToDataSetFrame.Initialize;
begin
  inherited;
end;


procedure TEntityToDataSetFrame.btEntityToDataSetClick(Sender: TObject);
var
  Dept: TDept;
begin
  // classic by class type
  Dept := DemoContext.GetEntity(TDept, 20) as TDept;
  EntityDataSet1.SourceEntity := Dept;
  EntityDataSet1.Open;

  ShowDemoPiece(Sender);
end;

procedure TEntityToDataSetFrame.Finalize;
begin
  inherited;
end;

end.
