unit LINQFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Grids, DB, DBGrids,
  EntityDAC.Linq.Expression,
  EntityDAC.Context,
  EntityDAC.Enumerable,
  EntityDAC.Entity,
  EntityDAC.EntityAttributes,
  DemoFrame,
  Demo.Context;

type
  TFrameLINQ = class(TDemoFrame)
    dbgQueryResults: TDBGrid;
    p2: TPanel;
    mmQueryDescription: TMemo;
    mmSQL: TMemo;
    grdResult: TStringGrid;
  private
    function GetContext: TDemoContext;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; virtual;
    function GetQuery(Index: integer): string; virtual;
    procedure ExecuteDemo(Index: integer);
    function GetUnitFolder: string; override;
    procedure FillGrid(Collection: IEnumerable);
  public
    procedure Initialize; override;
    procedure Finalize; override;

    property Context: TDemoContext read GetContext;
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Linq.Formatter,
  EntityDAC.MetaData,
  DemoForm,
  Demo.Linq;

type
  TDataContextUtil = class(TDataContext)
  end;

{ TFrameLINQ }

function TFrameLINQ.GetContext: TDemoContext;
begin
  Result := DemoContext;
end;

function TFrameLINQ.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin

end;

function TFrameLINQ.GetQuery(Index: integer): string;
begin

end;

procedure TFrameLINQ.ExecuteDemo(Index: integer);
var
  ProcedureName: string;
  Collection: IEnumerable;
begin
  try
    Collection := GetCollection(Index, ProcedureName);
    FillGrid(Collection);
    ShowDemoPiece(ProcedureName, mmQueryDescription.Lines);
  except
    on e: exception do begin
      if (Context <> nil) and
         (TDataContextUtil(Context).QueryCompiler <> nil) and
         (TDataContextUtil(Context).QueryCompiler.LastQuery <> nil)
      then
        mmSQL.Text := TDataContextUtil(Context).QueryCompiler.LastQuery.SQL;
      raise;
    end;
  end;

  mmSQL.Text := TDataContextUtil(Context).QueryCompiler.LastQuery.SQL;
end;

function TFrameLINQ.GetUnitFolder: string;
begin
  Result := 'LINQ';
end;

procedure TFrameLINQ.FillGrid(Collection: IEnumerable);
var
  i, j: integer;
  MetaType: TMetaType;
  EntitycCollection: IEntityEnumerable;
begin
  EntitycCollection := Collection as IEntityEnumerable;

  MetaType := EntitycCollection.MetaType;
  grdResult.ColCount := MetaType.MetaAttributes.Count;
  grdResult.RowCount := EntitycCollection.Count + 1;

  for i := 0 to MetaType.MetaAttributes.Count - 1 do
    grdResult.Cells[i, 0] := MetaType.MetaAttributes[i].Name;

  for i := 0 to EntitycCollection.Count - 1 do
    for j  := 0 to MetaType.MetaAttributes.Count - 1 do
      if EntitycCollection[i].Attributes[j].HasValue then
        grdResult.Cells[j, i + 1] := EntitycCollection[i].Attributes[j].AsString
      else
        grdResult.Cells[j, i + 1] := '';
end;

procedure TFrameLINQ.Finalize;
begin
  inherited;
end;

procedure TFrameLINQ.Initialize;
begin
  inherited;

  ExecuteDemo(Selector);
end;

end.
