unit LINQFrameAgg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  LINQFrame;

type
  TFrameLINQAgg = class(TFrameLINQ)
  private
    function CountSelect: IEnumerable;
    function CountWhere: IEnumerable;
    function CountResults: IEnumerable;
    function SumSelect: IEnumerable;
    function SumResults: IEnumerable;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
    function GetQuery(Index: integer): string; override;
  public
  end;

var
  FrameLINQAgg: TFrameLINQAgg;

implementation

uses
  EntityDAC.Linq,
  Demo.Linq;

{$R *.dfm}

function TFrameLINQAgg.CountResults: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select(D.DName)
               .Count.&As('DeptCount');

  Result := Context.GetEntities(Query);
end;

function TFrameLINQAgg.CountSelect: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select([D.DName, D.Emps.Count.&As('EmpsCount')]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQAgg.CountWhere: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Where(D.Emps.Count > 2)
               .Select(D.DName);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQAgg.SumResults: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Where(D.DeptNo = 10)
               .Select(D.Emps.RowType.Sal)
               .Sum.&As('SalSum');

  Result := Context.GetEntities(Query);
end;

function TFrameLINQAgg.SumSelect: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select([D.DName, D.Emps.Sum(D.Emps.RowType.Sal).&As('SalSum')]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQAgg.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := CountResults; ProcedureName := 'CountResults'; end;
    1: begin Result := CountSelect; ProcedureName := 'CountSelect'; end;
    2: begin Result := CountWhere; ProcedureName := 'CountWhere'; end;
    3: begin Result := SumResults; ProcedureName := 'SumResults'; end;
    4: begin Result := SumSelect; ProcedureName := 'SumSelect'; end;
  end;
end;

function TFrameLINQAgg.GetQuery(Index: integer): string;
begin
  case Index of
    0: Result := '';
    1: Result := 'from d in dept'#13#10'select new {d.dname, EmpsCount = d.emps.count()}';
    2: Result := 'from d in dept'#13#10'where d.emps.count() > 2'#13#10'select new {d.dname}';
    3: Result := '';
    4: Result := 'from d in dept'#13#10'select new {d.dname, SalSum = d.emps.sum(d.emps.sal)}';
  end;
end;

end.
