unit LINQFrameGroup;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  LINQFrame;

type
  TFrameLINQGroup = class(TFrameLINQ)
  private
    function GroupBy: IEnumerable;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
    function GetQuery(Index: integer): string; override;
  public
  end;

var
  FrameLINQGroup: TFrameLINQGroup;

implementation

uses
  EntityDAC.Linq,
  Demo.Linq;

{$R *.dfm}

function TFrameLINQGroup.GroupBy: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .GroupBy([E.Dept.DeptNo, E.Dept.DName])
               .Select([E.Dept.DName, E.Dept.Emps.Count.&As('EmpsCount')]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQGroup.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := GroupBy; ProcedureName := 'GroupBy'; end;
  end;
end;

function TFrameLINQGroup.GetQuery(Index: integer): string;
begin
  case Index of
    0: Result := 'from e in emp'#13#10'group e by e.dept.deptno, e.dept.dname'#13#10'select new {e.dept.dname, EmpsCount = e.dept.emps.count()}';
  end;
end;

end.
