unit LINQFrameJoin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  LINQFrame;

type
  TFrameLINQJoin = class(TFrameLINQ)
  private
    function JoinCross: IEnumerable;
    function JoinInner: IEnumerable;
    function JoinLeft: IEnumerable;
    function JoinRight: IEnumerable;
    function JoinFull: IEnumerable;
    function JoinSelf: IEnumerable;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
    function GetQuery(Index: integer): string; override;
  public
  end;

var
  FrameLINQJoin: TFrameLINQJoin;

implementation

uses
  EntityDAC.Linq,
  Demo.Linq;

{$R *.dfm}

function TFrameLINQJoin.JoinCross: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .Join(D)
               .Select([E.EName, D.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQJoin.JoinInner: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .Join(D).On(D.DeptNo = E.DeptNo)
               .Select([E.EName, D.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQJoin.JoinLeft: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .LeftJoin(D).On(D.DeptNo = E.DeptNo)
               .Select([E.EName, D.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQJoin.JoinRight: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .RightJoin(D).On(D.DeptNo = E.DeptNo)
               .Select([E.EName, D.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQJoin.JoinFull: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .FullJoin(D).On(D.DeptNo = E.DeptNo)
               .Select([E.EName, D.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQJoin.JoinSelf: IEnumerable;
var
  E: IEmpExpression;
  EE: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  EE := Context.Emp.Unique;

  Query := Linq.From(E)
               .LeftJoin(EE).On(EE.EmpNo = E.Mgr)
               .OrderBy(E.EName)
               .Select([E.EName, EE.EName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQJoin.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := JoinInner; ProcedureName := 'JoinInner'; end;
    1: begin Result := JoinLeft; ProcedureName := 'JoinLeft'; end;
    2: begin Result := JoinRight; ProcedureName := 'JoinRight'; end;
    3: begin Result := JoinCross; ProcedureName := 'JoinCross'; end;
    4: begin Result := JoinFull; ProcedureName := 'JoinFull'; end;
    5: begin Result := JoinSelf; ProcedureName := 'JoinSelf'; end;
  end;
end;

function TFrameLINQJoin.GetQuery(Index: integer): string;
begin
  case Index of
    0: Result := 'from e in emp'#13#10'join d in dept on d.deptno equals e.deptno'#13#10'select new {e.ename, d.dname}';
    1: Result := '';
    2: Result := '';
    3: Result := '';
    4: Result := '';
    5: Result := '';
  end;
end;

end.
