unit LINQFrameOrder;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  LINQFrame;

type
  TFrameLINQOrder = class(TFrameLINQ)
    function OrderBy: IEnumerable;
    function OrderByDesc: IEnumerable;
    function OrderByMultiple: IEnumerable;
    function ThenBy: IEnumerable;
    function ThenByDesc: IEnumerable;
  private
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
    function GetQuery(Index: integer): string; override;
  public
  end;

var
  FrameLINQOrder: TFrameLINQOrder;

implementation

uses
  EntityDAC.Linq,
  Demo.Linq;

{$R *.dfm}

function TFrameLINQOrder.OrderBy: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .OrderBy(E.EName)
               .Select([E.EName, E.Job, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQOrder.OrderByDesc: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .OrderByDescending(E.EName)
               .Select([E.EName, E.Job, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQOrder.OrderByMultiple: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .OrderBy([E.Job, E.EName])
               .Select([E.Job, E.EName, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQOrder.ThenBy: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .OrderBy(E.Job)
               .ThenBy(E.EName)
               .Select([E.Job, E.EName, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQOrder.ThenByDesc: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .OrderBy(E.Job)
               .ThenByDescending(E.EName)
               .Select([E.Job, E.EName, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQOrder.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := OrderBy; ProcedureName := 'OrderBy'; end;
    1: begin Result := OrderByDesc; ProcedureName := 'OrderByDesc'; end;
    2: begin Result := OrderByMultiple; ProcedureName := 'OrderByMultiple'; end;
    3: begin Result := ThenBy; ProcedureName := 'ThenBy'; end;
    4: begin Result := ThenByDesc; ProcedureName := 'ThenByDesc'; end;
  end;
end;

function TFrameLINQOrder.GetQuery(Index: integer): string;
begin
  case Index of
    0: Result := 'from e in emp'#13#10'orderby e.ename'#13#10'select new {e.ename, e.job, e.dept.dname}';
    1: Result := 'from e in emp'#13#10'orderby e.ename descending'#13#10'select new {e.ename, e.job, e.dept.dname}';
    2: Result := 'from e in emp'#13#10'orderby e.job, e.ename'#13#10'select new {e.ename, e.job, e.dept.dname}';
    3: Result := 'from e in emp'#13#10'orderby e.job'#13#10'thenby e.ename'#13#10'select new {e.ename, e.job, e.dept.dname}';
    4: Result := 'from e in emp'#13#10'orderby e.job'#13#10'thenby e.ename descending'#13#10'select new {e.ename, e.job, e.dept.dname}';
  end;
end;

end.
