unit LINQFrameParser;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, LINQFrame, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
  EDMemDS, EDVirtualDataSet, EntityDataSet, MemDSORM, VirtualDataset;

type
  TFrameLINQParser = class(TFrameLINQ)
    q: TEntityQuery;
    procedure btnExecuteClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

var
  FrameLINQParser: TFrameLINQParser;

implementation

{$R *.dfm}

uses
  Expression, Entity, DataContext, DataProvider, SqlFormatter, LinqParser, EntityEnumerable;

type
  TParserContextUtil = class(TDataContext)
  end;

{ TFrameLINQParser }

procedure TFrameLINQParser.btnExecuteClick(Sender: TObject);
begin
  CheckDataSet;

  try
    q.DataContext := DataContext;
    q.Linq.Text := mmQueryDescription.Lines.Text;
    q.Open;
    ds.DataSet := q;
  except
    on e: exception do begin
      if (DataContext <> nil) and
         (TParserContextUtil(DataContext).QueryCompiler <> nil) and
         (TParserContextUtil(DataContext).QueryCompiler.LastQuery <> nil)
      then
        mmSQL.Text := TParserContextUtil(DataContext).QueryCompiler.LastQuery.SQL;
      raise;
    end;
  end;

  mmSQL.Text := TParserContextUtil(DataContext).QueryCompiler.LastQuery.SQL;
end;

procedure TFrameLINQParser.Initialize;
begin
  mmQueryDescription.Text :=
    'from d in dept'#13#10 +
    'join e in emp on e.deptno equals d.deptno'#13#10 +
    'where d.deptno != null && d.deptno >= 1'#13#10 +
    'select new { dptno = e.deptno + 1 , dptname = d.dname, dptename = d.emps.ename,'#13#10 +
    '             dptcount = d.emps.count(), dptmax = d.emps.max(w => w.sal) }';
end;

end.
