unit LINQFramePart;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  LINQFrame;

type
  TFrameLINQPart = class(TFrameLINQ)
  private
    function Take: IEnumerable;
    function Skip: IEnumerable;
    function TakeSkip: IEnumerable;
    function First: IEnumerable;
    function ElementAt: IEnumerable;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
  public
  end;

var
  FrameLINQPart: TFrameLINQPart;

implementation

uses
  EntityDAC.Linq,
  Demo.Linq;

{$R *.dfm}

function TFrameLINQPart.Take: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .OrderBy(E.EmpNo)
               .Select([E.EmpNo, E.EName])
               .Take(5);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQPart.Skip: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .Select([E.EmpNo, E.EName])
               .Skip(1);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQPart.TakeSkip: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .Select([E.EmpNo, E.EName])
               .Skip(1)
               .Take(3);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQPart.First: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .OrderBy(E.EmpNo)
               .Select([E.EmpNo, E.EName])
               .First;

  Result := Context.GetEntities(Query);
end;

function TFrameLINQPart.ElementAt: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .OrderBy(E.EmpNo)
               .Select([E.EmpNo, E.EName])
               .ElementAt(5);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQPart.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := Take; ProcedureName := 'Take'; end;
    1: begin Result := Skip; ProcedureName := 'Skip'; end;
    2: begin Result := TakeSkip; ProcedureName := 'TakeSkip'; end;
    3: begin Result := First; ProcedureName := 'First'; end;
    4: begin Result := ElementAt; ProcedureName := 'ElementAt'; end;
  end;
end;

end.
