unit LINQFrameQuant;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  LINQFrame;

type
  TFrameLINQQuant = class(TFrameLINQ)
  private
    function AnyResults: IEnumerable;
    function AnyCondition: IEnumerable;
    function AnySelect: IEnumerable;
    function AllResults: IEnumerable;
    function AllSelect: IEnumerable;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
  public
  end;

var
  FrameLINQQuant: TFrameLINQQuant;

implementation

uses
  EntityDAC.Linq,
  Demo.Linq;

{$R *.dfm}

function TFrameLINQQuant.AnyResults: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Where(D.Emps.RowType.Sal > 10000)
               .Select(D.DName)
               .Any;

  Result := Context.GetEntities(Query);
end;

function TFrameLINQQuant.AnyCondition: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select([D.DName, D.Emps.RowType.Sal])
               .Any(D.Emps.RowType.Sal <= 1000);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQQuant.AnySelect: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select([D.DName, D.Emps.Any(D.Emps.RowType.Sal <= 1000)]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQQuant.AllResults: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select([D.DName, D.Emps.RowType.Sal])
               .All(D.Emps.RowType.Sal > 500);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQQuant.AllSelect: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select([D.DName, D.Emps.All(D.Emps.RowType.Sal > 1000)]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQQuant.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := AnyResults; ProcedureName := 'AnyResults'; end;
    1: begin Result := AnyCondition; ProcedureName := 'AnyCondition'; end;
    2: begin Result := AnySelect; ProcedureName := 'AnySelect'; end;
    3: begin Result := AllResults; ProcedureName := 'AllResults'; end;
    4: begin Result := AllSelect; ProcedureName := 'AllSelect'; end;
  end;
end;

end.
