unit LINQFrameSelect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  EntityDAC.Linq,
  LINQFrame;

type
  TFrameLINQSelect = class(TFrameLINQ)
  private
    function SelectSimple: IEnumerable;
    function SelectComplex: IEnumerable;
    function SelectFiltered: IEnumerable;
    function SelectMany: IEnumerable;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
    function GetQuery(Index: integer): string; override;
  public
  end;

var
  FrameLINQSelect: TFrameLINQSelect;

implementation

uses
  Demo.Linq;

{$R *.dfm}

function TFrameLINQSelect.SelectSimple: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select;

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSelect.SelectComplex: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .Select([E.EmpNo, E.EName, E.Job, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSelect.SelectFiltered: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .Where(E.Dept.DeptNo = 30)
               .Select([E.EmpNo, E.EName, E.Job, E.DeptNo, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSelect.SelectMany: IEnumerable;
var
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  D := Context.Dept;

  Query := Linq.From(D)
               .Select([D.DName, D.Emps.RowType.EName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSelect.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := SelectSimple; ProcedureName := 'SelectSimple'; end;
    1: begin Result := SelectComplex; ProcedureName := 'SelectComplex'; end;
    2: begin Result := SelectFiltered; ProcedureName := 'SelectFiltered'; end;
    3: begin Result := SelectMany; ProcedureName := 'SelectMany'; end;
  end;
end;

function TFrameLINQSelect.GetQuery(Index: integer): string;
begin
  case Index of
    0: Result := 'from d in dept'#13#10'select new {d}';
    1: Result := 'from e in emp'#13#10'select new {e.empno, e.ename, e.job, e.dept.dname}';
    2: Result := 'from e in emp'#13#10'where e.dept.deptno == 30'#13#10'select new {e.empno, e.ename, e.job, e.deptno, e.dept.dname}';
    3: Result := 'from d in dept'#13#10'select new {d.dname, d.emps.ename}';
  end;
end;

end.
