unit LINQFrameSet;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  LINQFrame;

type
  TFrameLINQSet = class(TFrameLINQ)
  private
    function Distinct: IEnumerable;
    function Union: IEnumerable;
    function Concat: IEnumerable;
    function _Except: IEnumerable;
    function Intersect: IEnumerable;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
  public
  end;

var
  FrameLINQSet: TFrameLINQSet;

implementation

uses
  EntityDAC.Linq,
  Demo.Linq;

{$R *.dfm}

function TFrameLINQSet.Distinct: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .Select(E.DeptNo)
               .Distinct;

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSet.Union: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .Select(E.EmpNo)
               .Union(Linq.From(D)
                          .Select(D.DeptNo));

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSet.Concat: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .Select(E.EmpNo)
               .Concat(Linq.From(D)
                           .Select(D.DeptNo));

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSet._Except: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .Select(E.EmpNo)
               .&Except(Linq.From(D)
                            .Select(D.DeptNo));

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSet.Intersect: IEnumerable;
var
  E: IEmpExpression;
  D: IDeptExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;
  D := Context.Dept;

  Query := Linq.From(E)
               .Select(E.EmpNo)
               .Intersect(Linq.From(D)
                              .Select(D.DeptNo));

  Result := Context.GetEntities(Query);
end;

function TFrameLINQSet.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := Distinct; ProcedureName := 'Distinct'; end;
    1: begin Result := Union; ProcedureName := 'Union'; end;
    2: begin Result := Concat; ProcedureName := 'Concat'; end;
    3: begin Result := _Except; ProcedureName := '_Except'; end;
    4: begin Result := Intersect; ProcedureName := 'Intersect'; end;
  end;
end;

end.
