unit LINQFrameWhere;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Grids, DBGrids, ExtCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  EntityDAC.Linq,
  LINQFrame;

type
  TFrameLINQWhere = class(TFrameLINQ)
  private
    function WhereComplex: IEnumerable;
    function WhereSimple: IEnumerable;
  protected
    function GetCollection(Index: integer; var ProcedureName: string): IEnumerable; override;
    function GetQuery(Index: integer): string; override;
  public
  end;

var
  FrameLINQWhere: TFrameLINQWhere;

implementation

uses
  Demo.Linq;

{$R *.dfm}

function TFrameLINQWhere.WhereSimple: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .Where(E.Dept.DeptNo = 30)
               .Select([E.EmpNo, E.EName, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQWhere.WhereComplex: IEnumerable;
var
  E: IEmpExpression;
  Query: ILinqQueryable;
begin
  E := Context.Emp;

  Query := Linq.From(E)
               .Where((E.Dept.DeptNo = 30) and (E.Comm <> null))
               .Select([E.EmpNo, E.EName, E.Dept.DName]);

  Result := Context.GetEntities(Query);
end;

function TFrameLINQWhere.GetCollection(Index: integer; var ProcedureName: string): IEnumerable;
begin
  case Index of
    0: begin Result := WhereSimple; ProcedureName := 'WhereSimple'; end;
    1: begin Result := WhereComplex; ProcedureName := 'WhereComplex'; end;
  end;
end;

function TFrameLINQWhere.GetQuery(Index: integer): string;
begin
  case Index of
    0: Result := 'from e in emp'#13#10'where e.dept.deptno == 30'#13#10'select new {e.empno, e.ename, e.dept.dname}';
    1: Result := 'from e in emp'#13#10'where e.dept.deptno == 30 && e.comm != null'#13#10'select new {e.empno, e.ename, e.dept.dname}';
  end;
end;

end.
