CREATE TABLE dept (
  deptno serial NOT NULL,
  dname character varying(14),
  loc character varying(13),
  CONSTRAINT dept_pkey PRIMARY KEY (deptno))
WITH (
  OIDS=FALSE);
--
INSERT INTO dept VALUES (10,'ACCOUNTING','NEW YORK');
--
INSERT INTO dept VALUES (20,'RESEARCH','DALLAS');
--
INSERT INTO dept VALUES (30,'SALES','CHICAGO');
--
INSERT INTO dept VALUES (40,'OPERATIONS','BOSTON');
--
CREATE TABLE emp (
  empno serial NOT NULL,
  ename character varying(10),
  job character varying(9),
  mgr integer,
  hiredate timestamp without time zone,
  sal real,
  comm real,
  deptno integer,
  CONSTRAINT emp_pkey PRIMARY KEY (empno),
  CONSTRAINT emp_deptno_fkey FOREIGN KEY (deptno) REFERENCES dept (deptno))
WITH (
  OIDS=FALSE
);
--
INSERT INTO emp VALUES (7369,'SMITH','CLERK',7902,'1980-12-17',800,NULL,20);
--
INSERT INTO emp VALUES (7499,'ALLEN','SALESMAN',7698,'1981-2-20',1600,300,30);
--
INSERT INTO emp VALUES (7521,'WARD','SALESMAN',7698,'1981-2-22',1250,500,30);
--
INSERT INTO emp VALUES (7566,'JONES','MANAGER',7839,'1981-4-2',2975,NULL,20);
--
INSERT INTO emp VALUES (7654,'MARTIN','SALESMAN',7698,'1981-9-28',1250,1400,30);
--
INSERT INTO emp VALUES (7698,'BLAKE','MANAGER',7839,'1981-5-1',2850,NULL,30);
--
INSERT INTO emp VALUES (7782,'CLARK','MANAGER',7839,'1981-6-9',2450,NULL,10);
--
INSERT INTO emp VALUES (7788,'SCOTT','ANALYST',7566,'1987-7-13',3000,NULL,20);
--
INSERT INTO emp VALUES (7839,'KING','PRESIDENT',NULL,'1981-11-17',5000,NULL,10);
--
INSERT INTO emp VALUES (7844,'TURNER','SALESMAN',7698,'1981-9-8',1500,0,30);
--
INSERT INTO emp VALUES (7876,'ADAMS','CLERK',7788,'1987-7-13',1100,NULL,20);
--
INSERT INTO emp VALUES (7900,'JAMES','CLERK',7698,'1981-12-3',950,NULL,30);
--
INSERT INTO emp VALUES (7902,'FORD','ANALYST',7566,'1981-12-3',3000,NULL,20);
--
INSERT INTO emp VALUES (7934,'MILLER','CLERK',7782,'1982-1-23',1300,NULL,10);