
//////////////////////////////////////////////////
//  MySQL Data Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//  MyDac About Window
//  Created:            24.07.01
//  Last modified:      14.01.02
//////////////////////////////////////////////////

{$I DacDemo.inc}

unit MyDacAbout;

interface
uses
{$IFDEF FPC}
  LResources,
{$ELSE}
{$IFDEF MSWINDOWS}
  Jpeg,
{$ENDIF}
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows, ShellApi,
{$ENDIF}
  SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, Buttons, ExtCtrls;

type
  TMyDacAboutForm = class(TForm)
    OKBtn: TButton;
    Image1: TImage;
    Label1: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    lbMail: TLabel;
    lbWeb: TLabel;
    Label4: TLabel;
    Bevel1: TBevel;
    Label10: TLabel;
    lbForum: TLabel;
    procedure lbWebClick(Sender: TObject);
    procedure lbMailClick(Sender: TObject);
    procedure lbWebMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbMailMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbForumMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbForumClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MyDacAboutForm: TMyDacAboutForm;

procedure ShowAbout;

implementation

{$IFNDEF FPC}
{$IFDEF CLR}
{$R *.nfm}
{$ELSE}
{$R *.dfm}
{$ENDIF}
{$ELSE}
{$R *.lfm}
{$ENDIF}

{$IFDEF FPC}
uses LCLIntf;
{$ENDIF}

procedure ShowAbout;
begin
  with TMyDacAboutForm.Create(Application) do
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TMyDacAboutForm.lbWebClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('https://www.devart.com/mydac');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, 'open', {$IFDEF FPC}PChar{$ENDIF}('https://www.devart.com/mydac'), '', '', SW_SHOW);
  lbWeb.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TMyDacAboutForm.lbMailClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('mailto:support@devart.com');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, 'open', {$IFDEF FPC}PChar{$ENDIF}('mailto:support@devart.com'), 'zxczxc', '', SW_SHOW);
  lbMail.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TMyDacAboutForm.lbForumClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('https://support.devart.com/portal/en/community/delphi-data-access-components/mysql-data-access-components');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, 'open', {$IFDEF FPC}PChar{$ENDIF}('https://support.devart.com/portal/en/community/delphi-data-access-components/mysql-data-access-components'), '', '', SW_SHOW);
  lbWeb.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TMyDacAboutForm.lbWebMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  lbWeb.Font.Color := $4080FF;
end;

procedure TMyDacAboutForm.lbMailMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  lbMail.Font.Color := $4080FF;
end;

procedure TMyDacAboutForm.lbForumMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  lbForum.Font.Color := $4080FF;
end;

procedure TMyDacAboutForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  lbWeb.Font.Color := $FF0000;
  lbMail.Font.Color := $FF0000;
  lbForum.Font.Color := $FF0000;
end;

end.
