
//////////////////////////////////////////////////
//  DB Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//////////////////////////////////////////////////

{$IFNDEF CLR}

{$I Dac.inc}

unit CRDesignUtils;
{$ENDIF}

interface

uses
  Classes, SysUtils;

type
  TCRDesignUtils = class
  public
    class function GetProjectName: string; virtual; // Returns ProjectName = ('DataEditor', 'ODAC', 'SDAC', 'MyDAC', ...)

  { Component }
    class function GetDesignCreate(Obj: TComponent): boolean; virtual;
    class procedure SetDesignCreate(Obj: TComponent; Value: boolean); virtual;

  {$IFDEF USE_SYNEDIT}
    class function SQLDialect: integer ; virtual; // SynHighlighterSQL TSQLDialect = (sqlStandard, sqlInterbase6, sqlMSSQL7, sqlMySQL, sqlOracle, sqlSybase, sqlIngres, sqlMSSQL2K);
  {$ENDIF}

    class function DBToolsAvailable: boolean; virtual;
  end;

  TCRDesignUtilsClass = class of TCRDesignUtils;

implementation

uses
  DAConsts;

{ TCRDesignUtils }

class function TCRDesignUtils.GetProjectName: string;
begin
 Result := 'DAC';
end;

class function TCRDesignUtils.GetDesignCreate(Obj: TComponent): boolean;
begin
  if Obj = nil then
    raise Exception.Create(Format(SInternalErrorInvalidValue,
      ['TCRDesignUtils.GetDesignCreate', 'Obj', nil]))
  else
    raise Exception.Create(Format(SInternalErrorInvalidValue,
      ['TCRDesignUtils.GetDesignCreate', 'Obj', Obj.ClassName]));
{$IFDEF FPC}
  Result := False;
{$ENDIF}
end;

class procedure TCRDesignUtils.SetDesignCreate(Obj: TComponent; Value: boolean);
begin
  if Obj = nil then
    raise Exception.Create(Format(SInternalErrorInvalidValue,
      ['TCRDesignUtils.SetDesignCreate', 'Obj', nil]))
  else
    raise Exception.Create(Format(SInternalErrorInvalidValue,
      ['TCRDesignUtils.SetDesignCreate', 'Obj', Obj.ClassName]));
end;

{$IFDEF USE_SYNEDIT}
class function TCRDesignUtils.SQLDialect: integer;
begin
  Result := 0; // sqlStandard
end;
{$ENDIF}

class function TCRDesignUtils.DBToolsAvailable: boolean;
begin
  Result := False;
end;

end.
