
//////////////////////////////////////////////////
//  MySQL Data Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//  MyDAC registration
//////////////////////////////////////////////////

{$IFNDEF CLR}

{$I MyDac.inc}

unit MyDacReg;
{$ENDIF}

interface

procedure Register;

implementation

uses                                  
  Classes, DBAccess, DacReg,
{$IFDEF FPC}
  LResources,
{$ENDIF}
  MyAccess, MyScript,
{$IFNDEF STD}
  CREncryption, MyLoader, MyDump, MyBackup, MyServerControl, MyEmbConnection,
{$ENDIF}
{$IFDEF CLR}
  MySQLMonitor,
{$ENDIF}
  MyDacVcl {$IFNDEF FPC}{$IFNDEF CLR}{$IFDEF VER9P}, Windows{$ENDIF}{$ENDIF}{$ENDIF};

{$IFNDEF FPC}
  {$IFDEF VER28P}
    {$R MyDesign28p.res}
  {$ELSE}
    {$IFDEF VER9}
      {$R MyDesign9.res}
    {$ELSE}
      {$R MyDesign.res}
    {$ENDIF}
    {$IFDEF VER10P}
      {$R MyDesign10p.res}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

procedure Register;
begin
{$IFNDEF FPC}
{$IFNDEF CLR}
{$IFDEF VER9P}
  RegisterSplashScreen('Devart MySQL Data Access Components',
                       MyDacVersion,
                       LoadBitmap(HInstance, {$IFDEF VER9}'SPLASHGR'{$ENDIF}
                                             {$IFDEF VER10}'SPLASHBL'{$ENDIF}
                                             {$IFDEF VER11}'SPLASHWH'{$ENDIF}
                                             {$IFDEF VER12}'SPLASHWH'{$ENDIF}
                                             {$IFDEF VER14P}'SPLASHBL'{$ENDIF}),
                     {$IFDEF BETA}
                       true, 'Beta'
                     {$ELSE}
                     {$IFDEF RC}
                       false, 'Release Candidate'
                     {$ELSE}
                     {$IFDEF TRIAL}
                       true, 'Trial'
                     {$ELSE} //ORIGINAL
                       false, 'Licensed'
                     {$ENDIF}
                     {$ENDIF}
                     {$ENDIF}
                      );
  RegisterAboutBox('Devart MySQL Data Access Components',
                   MyDacVersion,
                   'http://www.devart.com/mydac/',
                   'Devart MySQL Data Access Components' + #13#10 +
                   'Copyright 1998 - 2025 Devart. All rights reserved.' + #13#10 +
                   'Web: www.devart.com/mydac/' + #13#10 +
                   'Support: www.devart.com/mydac/support.html',
                   LoadBitmap(HInstance, 'ABOUT'),
                 {$IFDEF BETA}
                   true, 'Beta'
                 {$ELSE}
                 {$IFDEF RC}
                   false, 'Release Candidate'
                 {$ELSE}
                 {$IFDEF TRIAL}
                   true, 'Trial'
                 {$ELSE} //ORIGINAL
                   false, 'Licensed'
                 {$ENDIF}
                 {$ENDIF}
                 {$ENDIF}
                   , 
                 {$IFDEF STD}
                   'Standard edition'
                 {$ELSE}
                   'Professional edition'
                 {$ENDIF}
                  );
{$ENDIF}
{$ENDIF}
{$ENDIF}
{$IFNDEF STD}
  RegisterCRBatchMove;
{$ENDIF}

  RegisterComponents('MyDAC', [TMyConnection]);
  RegisterComponents('MyDAC', [TMyQuery]);
  RegisterComponents('MyDAC', [TMyTable]);
  RegisterComponents('MyDAC', [TMyStoredProc]);
  RegisterComponents('MyDAC', [TMyCommand]);
  RegisterComponents('MyDAC', [TMyScript]);
  RegisterComponents('MyDAC', [TMyUpdateSQL]);
  RegisterComponents('MyDAC', [TMyDataSource]);

{$IFNDEF STD}
  RegisterComponents('MyDAC', [TMyLoader]);
  RegisterComponents('MyDAC', [TMyDump]);
  RegisterComponents('MyDAC', [TMyBackup]);
  RegisterComponents('MyDAC', [TMyServerControl]);
  RegisterComponents('MyDAC', [TMyEmbConnection]);
{$ENDIF}
  RegisterComponents('MyDAC', [TMyMetaData]);

{$IFDEF CLR}
  RegisterComponents('MyDAC', [TMySQLMonitor]);
//  RegisterComponents('MyDAC', [MyDataAdapter]); - now in Devart.MyDac.DataReg.pas
{$ENDIF}
  RegisterComponents('MyDAC', [TMyConnectDialog]);
{$IFNDEF STD}
  RegisterComponents('MyDAC', [TMyEncryptor]);
{$ENDIF}
end;

{$IFDEF FPC}
initialization
  {$I MyDesign.lrs}
{$ENDIF}

end.
