# Python Connector for Microsoft Access #

Python Connector for Microsoft Access is a connectivity solution for accessing
Microsoft Access databases from Python applications. It fully implements
the Python DB API 2.0 specification. The connector is distributed as a wheel
package for Windows, macOS, and Linux.

Direct connection

Python offers a standard pyodbc module, which you can use to access Microsoft
Access databases through the Microsoft Access ODBC Driver. This method has
several disadvantages:
- Microsoft offers Access ODBC drivers only for the Windows platform.
- Users might experience issues opening databases created in the latest
versions of Microsoft Access.
- Users have to install either Microsoft Access or Microsoft Access Database
Engine Redistributable on their machine.
- By default, Microsoft Access is a single-user database system. An Access
database cannot be opened concurrently in multiple applications.
Our connector provides the following advantages:
- A direct access to a database without installing Microsoft Access or
Microsoft Access Database Engine Redistributable on the user's machine
- Support for all major desktop platforms: Windows, macOS, and Linux
- Support for the .mdb and .accdb file formats, including databases created
in the latest Microsoft Access versions
- A read-only multi-user mode to enable several users to read data from
a database simultaneously

## Connecting ##

To establish a connection to a Microsoft Access database, import the connector
and use the `connect()` method with your connection parameters.

### Import the connector ###

First, import the Access connector module:

```
import devart.access as access
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
my_connection = access.connect(
Database="path_to_db"
)
```

Replace `Database` with the actual path to your Access database file.

## Querying data ##

Once connected to Microsoft Access, you can execute SQL queries to retrieve
data from your Access database.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall():
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/access/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/access/activate-a-license.htm

## What's new ##

Python Connector for Microsoft Access 1.3

- Added support for Python 3.14
- Added CacheSize and CacheLifetime options to improve performance in the ExclusiveLock mode
- Added the PartialIndex option to improve SELECT performance
- Significantly improved the performance of DML operations executed within a transaction
