# Python Connector for BigCommerce #

Python Connector for BigCommerce is a connectivity solution for accessing
BigCommerce from Python applications to read and update data. It fully
implements the Python DB API 2.0 specification. The connector is distributed
as a wheel package for Windows, macOS, and Linux.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your BigCommerce data just like you would normally work
with relational databases. Simple queries are directly converted
to BigCommerce API calls and executed on the BigCommerce side.

## Connecting ##

To establish a connection to BigCommerce, import the connector and
authenticate using basic or OAuth 2.0 authentication.

### Import the connector ###

First, import the BigCommerce connector module:

```
import devart.bigcommerce as bigcommerce
```

### Establish a connection ###

Connect to your BigCommerce store using the `connect()` module method and obtain a `connection` object.

You can connect to BigCommerce using either basic authentication or OAuth 2.0 authentication.

#### Basic authentication ####

For basic authentication, provide your BigCommerce server URL and authentication credentials:

```
my_connection = bigcommerce.connect(
    Version="Ver2",    Authentication="Basic",    Server="your_bigcommerce_url",    UserId="your_username",    AuthenticationToken="your_auth_token"
)
```

Replace the example values with your actual connection values.

#### OAuth 2.0 authentication ####

For OAuth 2.0 authentication, provide your OAuth credentials:

```
my_connection = bigcommerce.connect(
    Version="Ver2",
    Authentication="OAuth",
    StoreId="your_store_hash",
    ClientId="your_client_id",
    AccessToken="your_access_token"
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected to BigCommerce, you can execute SQL queries to retrieve data
from your BigCommerce data.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute the SQL statement using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve the result set using one of the `fetch*()` cursor methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/bigcommerce/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/bigcommerce/activate-a-license.htm

## What's new ##

Python Connector for BigCommerce 1.3

- Added support for Python 3.14
