# Python Connector for Google BigQuery #

Python Connector for Google BigQuery is a connectivity solution for accessing
the Google BigQuery data warehouse from Python applications. It fully
implements the Python DB API 2.0 specification. The connector is distributed
as a wheel package for Windows and Windows Server.

GoogleSQL for BigQuery

The connector fully supports the BigQuery SQL dialects, data types, and query
syntax, including functions, operators, and conditional expressions.
Examples of supported BigQuery functions:

## Connecting ##

To establish a connection to Google BigQuery, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the BigQuery connector module:

```
import devart.bigquery as bigquery
```

### Establish a connection ###

Call the `connect()` method with the connection parameters for your BigQuery server and obtain a `connection` object.

```
response = bigquery.signin()
my_connection = bigquery.connect(
    ProjectId="your_project_id",
    DataSetId="your_dataset_id",
    RefreshToken=response["Refresh Token"]
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected, you can execute SQL queries to retrieve data from
your BigQuery datasets.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall():
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/bigquery/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/bigquery/activate-a-license.htm

## What's new ##

Python Connector for Google BigQuery 1.3

- Added support for Python 3.14
