# Python Connector for Dynamics 365 #

Python Connector for Dynamics 365 is a connectivity solution for accessing
Dynamics 365 Customer Engagement (formerly Dynamics CRM) from Python
applications to read and update data. It fully implements the Python DB API
2.0 specification. The connector is distributed as a wheel package
for Windows, macOS, and Linux.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your Dynamics 365 data just like you would normally work
with relational databases. Simple queries are directly converted to Dynamics
365 API calls and executed on the Dynamics 365 side.

## Connecting ##

To establish a connection to Dynamics 365, import the connector and
authenticate using basic or OAuth 2.0 authentication.

### Import the connector ###

First, import the Dynamics 365 connector module:

```
import devart.dynamics365 as dynamics365
```

### Establish a connection ###

Connect to your Dynamics 365 environment using the `connect()` module method and obtain a `connection` object.

You can connect to Dynamics 365 using either basic authentication or OAuth 2.0 authentication.

#### Basic authentication ####

For basic authentication, provide your Dynamics 365 server URL and authentication credentials:

```
my_connection = dynamics365.connect(
    Authentication="Basic",    Server="your_dynamics365_url",    UserId="your_username",    Password="your_password"
)
```

Replace the example values with your actual connection values.

#### OAuth 2.0 authentication ####

For OAuth 2.0 authentication, provide your OAuth credentials:

```
response = dynamics365.signin(Server="your_dynamics365_url")
my_connection = dynamics365.connect(
    Authentication="OAuth",
    Server="your_dynamics365_url",
    RefreshToken=response["Refresh Token"]
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected to Dynamics 365, you can execute SQL queries to retrieve data
from your Dynamics 365 data.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute the SQL statement using the `execute()` cursor method.
```
my_cursor.execute("SELECT * from product")
```
Retrieve the result set using one of the `fetch*()` cursor methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/dynamics/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/dynamics/activate-a-license.htm

## What's new ##

Python Connector for Dynamics 365 1.3

- Added support for Python 3.14
