# Python Connector for Dynamics 365 Business Central #

Python Connector for Dynamics 365 Business Central is a connectivity solution
for accessing Dynamics 365 Business Central from Python applications to read
and update data. It fully implements the Python DB API 2.0 specification.
The connector is distributed as a wheel package for Windows and Windows
Server.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your Dynamics 365 Business Central data just like you would
normally work with relational databases. Simple queries are directly converted
to Dynamics 365 BC API calls and executed on the Dynamics 365 BC side.

## Connecting ##

To establish a connection to Dynamics 365 Business Central, import
the connector and use the `connect()` method with your connection parameters.

### Import the connector ###

First, import the Dynamics connector module:

```
import devart.dynamicsbc as dynamicsbc
```

### Establish a connection ###

Connect to your Dynamics 365 Business Central environment using the `connect()` module method and obtain a `connection` object.

You can connect to Dynamics 365 Business Central using either basic authentication or OAuth 2.0 authentication.

#### Basic authentication ####

For basic authentication, provide your Dynamics 365 Business Central server URL and authentication credentials:

```
my_connection = dynamicsbc.connect(
    Authentication="Basic",    Server="your_dynamics365_url",    UserId="your_username",    AccessKey="your_access_key",    CompanyId="your_company_id"
)
```

Replace the example values with your actual connection values.

#### OAuth 2.0 authentication ####

For OAuth 2.0 authentication, first obtain a refresh token, then retrieve your environments and companies, and finally establish the connection:

```
response = dynamicsbc.signin()
my_environments = dynamicsbc.getenvironments(
    RefreshToken=response["Refresh Token"]
)
my_companies = dynamicsbc.getcompanies(
    RefreshToken=response["Refresh Token"],
    Environment=my_environments[0]
)
my_connection = dynamicsbc.connect(
    Authentication="OAuth",
    RefreshToken=response["Refresh Token"],
    Environment=my_environments[0],
    CompanyId=my_companies[0]["Company Id"]
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected, you can execute SQL queries to retrieve data from
your Dynamics 365 Business Central environment.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM Company")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/dynamicsbc/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/dynamicsbc/activate-a-license.htm

## What's new ##

Python Connector for Dynamics 365 Business Central 1.1

- Added support for Python 3.14
