# Python Connector for Dynamics 365 Business Central #

Python Connector for Dynamics 365 Business Central is a connectivity solution
for accessing Dynamics 365 Business Central from Python applications to read
and update data. It fully implements the Python DB API 2.0 specification.
The connector is distributed as a wheel package for Windows and Windows
Server.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your Dynamics 365 Business Central data just like you would
normally work with relational databases. Simple queries are directly converted
to Dynamics 365 BC API calls and executed on the Dynamics 365 BC side.
Complex queries are transformed into simpler queries, which are then converted
to Dynamics 365 BC API calls. The embedded SQL engine then processes
the results in the local cache and applies advanced SQL features from
the original complex query.

## Using the connector ##

To retrieve data from [!ProductNameMix]:

Import the module.
```
import devart.dynamicsbc as dynamicsbc
```

Connect to a database using the `connect()` module method and obtain a `connection` object: 
If you're using basic authentication:
```
my_connection = dynamicsbc.connect(
    Authentication="Basic",
    Server="your_dynamics365_url",
    UserId="your_username",
    AccessKey="your_access_key",
    CompanyId="your_company_id"
)
```
If you're using OAuth 2.0 authentication:
```
response = dynamicsbc.signin()
my_environments = dynamicsbc.getenvironments(
    RefreshToken=response["Refresh Token"]
)
my_companies = dynamicsbc.getcompanies(
    RefreshToken=response["Refresh Token"],
    Environment=my_environments[0]
)
my_connection = dynamicsbc.connect(
    Authentication="OAuth",
    RefreshToken=response["Refresh Token"],
    Environment=my_environments[0],
    CompanyId=my_companies[0]["Company Id"]
)
```

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```

Execute the SQL statement using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM Company")
```

Retrieve the result set using one of the `fetch*()` cursor methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/dynamicsbc/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/dynamicsbc/activate-a-license.htm

## What's new ##

Python Connector for Dynamics 365 Business Central 1.0 Beta

- Initial release of Python Connector for Dynamics 365 Business Central
- Added support for Windows 32-bit and 64-bit
- Added support for Windows Server 32-bit and 64-bit
