# Python Connector for Microsoft Excel #

Python Connector for Microsoft Excel is a connectivity solution for accessing
Microsoft Excel, Apache OpenOffice Calc, and LibreOffice Calc spreadsheets
from Python applications. It fully implements the Python DB API 2.0
specification. The connector is distributed as a wheel package for Windows,
macOS, and Linux.

Direct connection

Our connector provides the following advantages:
- A direct access to an Excel workbook without installing Microsoft Excel or
Microsoft Access Database Engine Redistributable components on the user's
machine
- Support for all major desktop platforms: Windows, macOS, and Linux
- Support for the Microsoft Excel 2007-2021 Workbook (.xlsx), Microsoft Excel
97-2003 Workbook (.xls), and OpenDocument Spreadsheet (.ods) file formats
- A read-only multi-user mode that enables several users to read data from
a workbook simultaneously

## Connecting ##

To establish a connection to Microsoft Excel, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the Microsoft Excel connector module:

```
import devart.excel as excel
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
my_connection = excel.connect(
    Database="path_to_workbook"
)
```

Replace `Database` with the actual path to your Microsoft Excel database file.

## Querying data ##

Once connected to Microsoft Excel, you can execute SQL queries to retrieve
data from your Excel workbooks.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/excel/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/excel/activate-a-license.htm

## What's new ##

Python Connector for Microsoft Excel 1.2

- Added support for Python 3.14
- Improved detection of column data types
