# Python Connector for Microsoft Excel Online #

Python Connector for Microsoft Excel Online is a connectivity solution
for accessing Microsoft Excel Online from Python applications to read and
update data. It fully implements the Python DB API 2.0 specification.
The connector is distributed as a wheel package for Windows and Windows
Server.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your Microsoft Excel Online data just like you would
normally work with relational databases. Simple queries are directly converted
to Microsoft Excel Online API calls and executed on the Microsoft Excel Online
side.
Complex queries are transformed into simpler queries, which are then converted
to Microsoft Excel Online API calls. The embedded SQL engine then processes
the results in the local cache and applies advanced SQL features from
the original complex query.

## Using the connector ##

To retrieve data from [!ProductNameMix]:

Import the module.
```
import devart.excelonline as excelonline
```

Connect to a database using the `connect()` module method and obtain a `connection` object.
```
response = excelonline.signin()
my_workbook = excelonline.getworkbook()
my_connection = excelonline.connect(
    WorkbookId=my_workbook["Workbook Id"]
    RefreshToken=response["Refresh Token"]
)
```
Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute the SQL statement using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM all_types")
```
Retrieve the result set using one of the `fetch*()` cursor methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/excelonline/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/excelonline/activate-a-license.htm

## What's new ##

Python Connector for Microsoft Excel Online 1.0 Beta

- Initial release of Python Connector for Microsoft Excel Online
- Added support for Windows 32-bit and 64-bit
- Added support for Windows Server 32-bit and 64-bit
