# Python Connector for Google Sheets #

Python Connector for Google Sheets is a connectivity solution for accessing
Google Sheets Customer Engagement from Python applications to read and update
data. It fully implements the Python DB API 2.0 specification. The connector
is distributed as a wheel package for Windows and Windows Server.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your Google Sheets data just like you would normally work
with relational databases. Simple queries are directly converted to Google
Sheets API calls and executed on the Google Sheets side.

## Connecting ##

To establish a connection to Google Sheets, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the Google Sheets connector module:

```
import devart.googlesheets as googlesheets
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
response = googlesheets.signin()
my_spreadsheet = googlesheets.getspreadsheet("RefreshToken=" + response["Refresh Token"])
my_connection = googlesheets.connect(
    SpreadsheetId=my_spreadsheet["Spreadsheet Id"]
    RefreshToken=response["Refresh Token"]
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected to Google Sheets, you can execute SQL queries to retrieve data
from your spreadsheets.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM Company")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/googlesheets/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/googlesheets/activate-a-license.htm

## What's new ##

Python Connector for Google Sheets 1.1

- Added support for Python 3.14
