# Python Connector for HubSpot #

Python Connector for HubSpot is a connectivity solution for accessing HubSpot
from Python applications to read and update data. It fully implements
the Python DB API 2.0 specification. The connector is distributed as a wheel
package for Windows and Windows Server.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your HubSpot data just like you would normally work with
relational databases. Simple queries are directly converted to HubSpot API
calls and executed on the HubSpot side.

## Connecting ##

To establish a connection to HubSpot, import the connector and authenticate
using basic or OAuth 2.0 authentication.

### Import the connector ###

First, import the HubSpot connector module:

```
import devart.hubspot as hubspot
```

### Establish a connection ###

Connect to your HubSpot account using the `connect()` module method and obtain a `connection` object.

You can connect to HubSpot using API key, access token, or OAuth 2.0 authentication.

#### API key authentication ####

For API key authentication, provide your HubSpot API key:

```
my_connection = hubspot.connect(
    Authentication="APIKey",    APIKey="your_api_key"
)
```

Replace the example value with your actual API key.

#### Access token authentication ####

For access token authentication, provide your HubSpot access token:

```
my_connection = hubspot.connect(
    Authentication="PrivateApp",
    AccessToken="your_access_token"
)
```

Replace the example value with your actual access token.

#### OAuth 2.0 authentication ####

For OAuth 2.0 authentication, first obtain a refresh token, then use it to establish the connection:

```
response = devart.hubspot.signin()
my_connection = hubspot.connect(
    Authentication="OAuth",
    RefreshToken=response["Refresh Token"]
)
```

Replace the example values with your actual refresh token.

## Querying data ##

Once connected to HubSpot, you can execute SQL queries to retrieve data from
HubSpot.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall():
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the 

`execute()`

 method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/hubspot/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/hubspot/activate-a-license.htm

## What's new ##

Python Connector for HubSpot 1.3

- Added support for Python 3.14
- Extended the list of supported tables
