# Python Connector for InterBase #

Python Connector for InterBase is a connectivity solution for accessing
InterBase databases from Python applications. It fully implements the Python
DB API 2.0 specification. The connector is distributed as a wheel package
for Windows, macOS, and Linux.

Secure communication

## Connecting ##

To connect to an InterBase database, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the InterBase connector module:

```
import devart.interbase as interbase
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
my_connection = interbase.connect(
    Server="your_server",    Database="your_database",    UserId="your_username",    Password="your_password",    ClientLibrary="your_client_library"
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected to InterBase, you can execute SQL queries to retrieve data from
your database.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/interbase/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/interbase/activate-a-license.htm

## What's new ##

Python Connector for InterBase 1.3

- Added support for Python 3.14
