# Python Connector for MongoDB #

Python Connector for MongoDB is a connectivity solution for accessing MongoDB
databases from Python applications. It fully implements the Python DB API 2.0
specification. The connector is distributed as a wheel package for Windows,
macOS, and Linux.

## Connecting ##

To establish a connection to a MongoDB database, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the MongoDB connector module:

```
import devart.mongodb as mongodb
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
my_connection = mongodb.connect(
    Server="your_server",    Database="your_database",    Username="your_username",    Password="your_password",    ClientLibary="path_to_libmongoc",    BSONLibrary="path_to_libbson"
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected to MongoDB, you can execute SQL queries to retrieve data from
your database.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/mongodb/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/mongodb/activate-a-license.htm

## What's new ##

Python Connector for MongoDB 1.3

- Added support for Python 3.14
