# Python Connector for NetSuite #

Python Connector for NetSuite is a connectivity solution for accessing
NetSuite from Python applications to read and update data. It fully implements
the Python DB API 2.0 specification. The connector is distributed as a wheel
package for Windows and Windows Server.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your NetSuite data just like you would normally work with
relational databases. Simple queries are directly converted to NetSuite API
calls and executed on the NetSuite side.

## Connecting ##

To establish a connection to NetSuite, import the connector and authenticate
using basic, token-based, or OAuth 2.0 authentication.

### Import the connector ###

First, import the NetSuite connector module:

```
import devart.netsuite as netsuite
```

### Establish a connection ###

Connect to your NetSuite account using the `connect()` module method and obtain a `connection` object.

You can connect to NetSuite using basic, token-based, or OAuth 2.0 authentication.

#### Basic authentication ####

For basic authentication, provide your NetSuite account details:

```
my_connection = netsuite.connect(
    Ver=1,    Authentication="Basic",    UserID="your_username",    Password="your_password",    AccountId="your_account_id",    RoleId="your_role_id",    ApplicationId="your_application_id"
)
```

Replace the example values with your actual NetSuite credentials.

#### Token-based authentication ####

For token-based authentication, provide your NetSuite account and token details:

```
my_connection = netsuite.connect(
    Version="Ver2",
    Authentication="TokenBased",
    AccountId="your_account_id",
    AccountTimeZone="your_account_timezone",
    ConsumerKey="your_consumer_key",
    ConsumerSecret="your_consumer_secret",
    TokenId="your_token_id",
    TokenSecret="your_token_secret"
)
```

Replace the example values with your actual token credentials.

#### OAuth 2.0 authentication ####

For OAuth 2.0 authentication, first obtain a refresh token, then use it to establish the connection:

```
response = netsuite.signin(
    AccountId="your_account_id",
    ClientId="your_client_id",
    ClientSecret="your_client_secret")
my_connection = netsuite.connect(
    Authentication="OAuth",
    AccountID="your_account_id",
    AccountTimeZone="your_account_timezone",
    ClientID="your_client_id",
    ClientSecret="your_client_secret",
    RefreshToken=response["Refresh Token"]
)
```

Replace the example values with your actual OAuth credentials.

## Querying data ##

Once connected to NetSuite, you can execute SQL queries to retrieve data from
NetSuite.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the 

`execute()`

 method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/netsuite/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/netsuite/activate-a-license.htm

## What's new ##

Python Connector for NetSuite 1.3

- Added support for Python 3.14
