# Python Connector for PostgreSQL #

Python Connector for PostgreSQL is a connectivity solution for accessing
PostgreSQL databases from Python applications. It fully implements the Python
DB API 2.0 specification. The connector is distributed as a wheel package
for Windows, macOS, and Linux.

Direct connection

The connector enables you to establish a direct connection to PostgreSQL from
a Python application via TCP/IP, eliminating the need for the database client
library. A direct connection increases the speed of data transmission between
the application and PostgreSQL database server. It also streamlines
the deployment process since you don't have to distribute any client
libraries with the application.

Secure communication

## Connecting ##

To establish a connection to a PostgreSQL database, import the connector and
use the `connect()` method with your connection parameters.

### Import the connector ###

First, import the PostgreSQL connector module:

```
import devart.postgresql as postgresql
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
my_connection = postgresql.connect(
    Server="your_server",    Database="your_database",    UserId="your_username",    Password="your_password"
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected to PostgreSQL, you can execute SQL queries to retrieve data
from your PostgreSQL database.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/postgresql/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/postgresql/activate-a-license.htm

## What's new ##

Python Connector for PostgreSQL 1.3

- Added support for Python 3.14
- Added support for PostgreSQL 18
- Added support for the Bearer Token authentication when using an HTTP tunnel
- Added support for password-protected private keys for the SSL protocol
- Added support for the COPY ... TO STDOUT statement
- Improved support for array data types
- Improved performance in opening a connection
