# Python Connector for QuickBooks Online #

Python Connector for QuickBooks Online is a connectivity solution
for accessing QuickBooks Online Online from Python applications to read and
update data. It fully implements the Python DB API 2.0 specification.
The connector is distributed as a wheel package for Windows and Windows
Server.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your QuickBooks Online data just like you would normally
work with relational databases. Simple queries are directly converted
to QuickBooks Online API calls and executed on the QuickBooks Online side.
Complex queries are transformed into simpler queries, which are then converted
to QuickBooks Online API calls. The embedded SQL engine then processes
the results in the local cache and applies advanced SQL features from
the original complex query.

## Using the connector ##

To retrieve data from a database:

Import the module.
```
import devart.quickbooks
```

Connect to a database using the `connect()` module method and obtain a `connection` object: 
If you have a refresh token and know your company ID:
```
my_connection = devart.quickbooks.connect(
    CompanyId="your_company_id",
    RefreshToken="your_refresh_token"
)
```
If you don't have a refresh token or don't know your company ID:
```
response = devart.quickbooks.signin()
my_connection = devart.quickbooks.connect(
    CompanyId=response["Company Id"],
    RefreshToken=response["Refresh Token"]
)
```

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```

Execute the SQL statement using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```

Retrieve the result set using one of the `fetch*()` cursor methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/quickbooks/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/quickbooks/activate-a-license.htm

## What's new ##

Python Connector for QuickBooks Online 1.2

- Added support for Python 3.13
