# Python Connector for Salesforce #

Python Connector for Salesforce is a connectivity solution for accessing
Salesforce from Python applications to read and update data. It fully
implements the Python DB API 2.0 specification. The connector is distributed
as a wheel package for Windows, macOS, and Linux.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your Salesforce data just like you would normally work with
relational databases. Simple queries are directly converted to Salesforce API
calls and executed on the Salesforce side.

## Connecting ##

To establish a connection to Salesforce, import the connector and authenticate
using basic or OAuth 2.0 authentication.

### Import the connector ###

First, import the Salesforce connector module:

```
import devart.salesforce as salesforce
```

### Establish a connection ###

Connect to your Salesforce org using the `connect()` module method and obtain a `connection` object: 
You can connect to Salesforce using either basic authentication or OAuth 2.0 authentication.
#### Basic authentication ####
For basic authentication, provide your Salesforce credentials and security token:
```
my_connection = salesforce.connect(
    Authentication="Basic",
    Host="login.salesforce.com",
    UserId="your_username",
    UserPassword="your_password",
    SecurityToken="your_token"
)
```
Replace the example values with your actual connection values.

#### OAuth 2.0 authentication ####
For OAuth 2.0 authentication, first obtain a refresh token, then use it to establish the connection:
```
response = salesforce.signin(Host="login.salesforce.com")
my_connection = salesforce.connect(
    Authentication="OAuth",
    Host="login.salesforce.com",
    RefreshToken=response["Refresh Token"]
)
```
Replace the example values with your actual connection values.

? 2022-2025 Devart. All Rights Reserved.
Request Support
Python Connectors Forum
Provide Feedback
            hljs.tabReplace = '    ';
            hljs.initHighlighting();
            

## Querying data ##

Once connected to Salesforce, you can execute SQL queries to retrieve data
from your Salesforce org.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall():
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the 

`execute()`

 method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/salesforce/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/salesforce/activate-a-license.htm

## What's new ##

Python Connector for Salesforce 1.3

- Added support for Python 3.14
